# V2Math Simulation — Acceptance Bundle (Passed Version)

This repository bundles the **passed** simulation artifacts, manifest, and a tiny replay harness
so you can verify the run, inspect the results, and regenerate summary plots locally.

> **What’s included:** results (`artifacts/`), the exact manifest used (`manifests/manifest.json`),
> an audit report (`artifacts/audit.json`), and helper scripts in `scripts/`.  
> **What’s *not* included:** the closed-source simulation engine itself. The helper scripts here
> *replay* and validate the already-passed run using the saved artifacts.

---

## Quick start

```bash
python -m venv .venv
source .venv/bin/activate  # Windows: .venv\Scripts\activate
pip install -r requirements.txt

# Print a one-line PASS/FAIL summary from artifacts/audit.json
python scripts/run.py --summary

# Generate basic exploratory plots from artifacts/*.csv and artifacts/readouts.json
python scripts/run.py --plots --outdir artifacts/plots
```

If you prefer `make`:

```bash
make summary
make plots
```

---

## Repo layout

```
v2math-sim-acceptance/
├─ manifests/
│  └─ manifest.json             # exact manifest used for the passing run
├─ artifacts/
│  ├─ audit.json                # audit/acceptance summary indicating PASS
│  ├─ report.md                 # human-readable report of the run
│  ├─ readouts.json             # structured readouts captured during the run
│  ├─ flow_tcg.csv              # result table (if present)
│  ├─ jfm.csv                   # result table (if present)
│  └─ plots/                    # generated locally by scripts/run.py --plots
├─ scripts/
│  └─ run.py                    # CLI: --summary and --plots
├─ requirements.txt
├─ Makefile
└─ LICENSE
```

---

## Repro & provenance

* `artifacts/audit.json` contains the acceptance verdict and key metrics distilled from the run.
* `artifacts/report.md` is the narrative report that shipped with the passing artifacts.
* `manifests/manifest.json` is the single source of truth for the configuration used.

The run follows the **V2.1 governance contract** (gates-first → exact fit (ratio/lex) → PF/Born for ties; neighbor-only composition; canonical hinge measure; rational unit map `c`). See the governance notes in your source docs for details.

---

## Notes

* These scripts are deliberately minimal and **do not** attempt to re-run the proprietary solver;
  they simply validate and visualize the shipped artifacts.
* If you later drop a compatible solver into this repo, point it at `manifests/manifest.json`
  and emit new artifacts under `artifacts/`—the same helper scripts will pick them up.

